<?php
global $GAMES;
$gameType = isset($_GET['type']) ? $_GET['type'] : '30s';
$game = isset($GAMES[$gameType]) ? $GAMES[$gameType] : $GAMES['30s'];
?>
<!-- GAME PLAY INTERFACE -->
<div id="game-view">
    <div class="game-nav">
        <button onclick="goHome()" class="back-btn"><i class="fas fa-chevron-left"></i> Lobby</button>
        <h3 id="game-title"><?php echo $game['name']; ?></h3>
        <div style="width: 40px;"></div>
    </div>

    <div class="game-frame">
        <div class="timer-box">
            <div class="timer-info">
                <p>Period</p>
                <h3 id="period-num">Loading...</h3>
            </div>
            <div class="timer-clock">
                <p>Time Remaining</p>
                <div id="countdown">00:00</div>
            </div>
        </div>

        <div class="bet-controls">
            <div class="color-row">
                <button class="btn-bet btn-green" onclick="openBetPopup('Green')">Green</button>
                <button class="btn-bet btn-violet" onclick="openBetPopup('Violet')">Violet</button>
                <button class="btn-bet btn-red" onclick="openBetPopup('Red')">Red</button>
            </div>
            <div class="number-grid">
                <button class="ball-btn ball-0" onclick="openBetPopup('0')"></button>
                <button class="ball-btn ball-1" onclick="openBetPopup('1')"></button>
                <button class="ball-btn ball-2" onclick="openBetPopup('2')"></button>
                <button class="ball-btn ball-3" onclick="openBetPopup('3')"></button>
                <button class="ball-btn ball-4" onclick="openBetPopup('4')"></button>
                <button class="ball-btn ball-5" onclick="openBetPopup('5')"></button>
                <button class="ball-btn ball-6" onclick="openBetPopup('6')"></button>
                <button class="ball-btn ball-7" onclick="openBetPopup('7')"></button>
                <button class="ball-btn ball-8" onclick="openBetPopup('8')"></button>
                <button class="ball-btn ball-9" onclick="openBetPopup('9')"></button>
            </div>
            <div class="size-row">
                <button class="btn-size btn-big" onclick="openBetPopup('Big')">Big</button>
                <button class="btn-size btn-small" onclick="openBetPopup('Small')">Small</button>
            </div>
        </div>
    </div>

    <div class="history-section">
        <div class="tab-menu">
            <div class="tab-item active" onclick="switchHistory('game')">Game Record</div>
            <div class="tab-item" onclick="switchHistory('my')">My Bets</div>
        </div>
        <div class="table-wrap">
            <table id="history-table">
                <thead>
                    <tr>
                        <th>Period</th>
                        <th>Number</th>
                        <th>Big/Small</th>
                        <th>Color</th>
                    </tr>
                </thead>
                <tbody id="history-body">
                    <tr><td colspan="4">Loading...</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
// গেম টাইপ সেট
activeGame = '<?php echo $gameType; ?>';
runTimer();

// হিস্ট্রি ট্যাব সুইচ
function switchHistory(type) {
    const tabs = document.querySelectorAll('.tab-item');
    tabs.forEach(tab => tab.classList.remove('active'));
    
    if (type === 'game') {
        tabs[0].classList.add('active');
        loadGameHistory();
    } else {
        tabs[1].classList.add('active');
        loadMyBets();
    }
}

async function loadMyBets() {
    if (!activeGame) return;
    
    try {
        const response = await fetch(`index.php?ajax=getMyBets&game=${activeGame}`);
        const result = await response.json();
        
        if (result.success && document.getElementById('history-body')) {
            let html = '';
            result.bets.forEach(bet => {
                html += `<tr>
                    <td>${bet.period.slice(-4)}</td>
                    <td>${bet.bet_type}</td>
                    <td>${bet.amount}</td>
                    <td>${bet.outcome}</td>
                </tr>`;
            });
            document.getElementById('history-body').innerHTML = html;
        }
    } catch (error) {
        console.error('Error loading my bets:', error);
    }
}
</script>